_base_ = [
    '../_base_/models/retinanet_r50_fpn.py',
    '../_base_/datasets/coco_detection.py',
    '../_base_/schedules/schedule_1x.py', '../_base_/default_runtime.py'
]
pretrained = './checkpoints/swin_base_patch4_window7_224.pth'  # noqa
model = dict(
    backbone=dict(
        _delete_=True,
        type='SwinTransformer',
        embed_dims=128,
        depths=[2, 2, 18, 2], 
        num_heads=[4, 8, 16,32],
        window_size=7,
        mlp_ratio=4,
        qkv_bias=True,
        qk_scale=None,
        drop_rate=0.,
        attn_drop_rate=0.,
        drop_path_rate=0.2,
        patch_norm=True,
        out_indices=(1, 2, 3),
        # Please only add indices that would be used
        # in FPN, otherwise some parameter will not be used
        with_cp=False,
        convert_weights=True,
        init_cfg=dict(type='Pretrained', checkpoint=pretrained)),
    neck=dict(in_channels=[256, 512, 1024], start_level=0, num_outs=5))

# optimizer
optim_wrapper = dict(optimizer=dict(lr=0.01))
max_epochs = 12
param_scheduler = [
    dict(begin=0, by_epoch=False, end=500, start_factor=0.001, type='LinearLR'),
    # dict(
    #     type='MultiStepLR',
    #     begin=0,
    #     end=max_epochs,
    #     by_epoch=True,
    #     milestones=[8, 11],
    #     gamma=0.1)
    dict(
        type='CosineAnnealingLR',
        begin=500,
        end=max_epochs * 14659,
        eta_min=1e-7,
        by_epoch=False
    )
]